open Batteries
open Term
open Mapping
open Cnf
open Arglean.Lean
open Arglean.Trace
open Common
open Database.Clausal.ListDb
open Print
open Proof.Clausal.Step

module Subst = Substitution.Substoff (Substitution.Substarray)

let rec prove sub hist alt (todo, prf) = function
  | [] -> todo (sub, alt, prf)
  | (lit1 :: rest as cl) ->
     let (path, lem, lim) = hist in
     if (List.exists (fun x -> List.exists (Subst.eq sub x) path)) cl then ((if !verbose then Format.printf "regularity\n%!"); alt ()) else
     begin
     if !verbose then Format.printf "Lit: %s\n%!" (string_of_lit lit1);
     if !verbose then Format.printf "Path: %s\n%!" (string_of_lits path);
     if !verbose then Format.printf "Lemmas: %s\n%!" (string_of_lits lem);
     if List.exists (Subst.eq sub lit1) lem then begin
       if !verbose then Format.printf "lemma\n%!";
       prove sub hist (if !cut1 then alt else (fun () -> reduce sub lit1 rest hist alt (todo, prf) (negate_lit lit1) path)) (todo, Lem lit1 :: prf) rest
     end
     else reduce sub lit1 rest hist alt (todo, prf) (negate_lit lit1) path
     end

and reduce sub lit1 rest hist alt (todo, prf) neglit = function
  | plit :: pt -> if !verbose then Format.printf "Reduction try %s\n%!" (string_of_lit plit);
    (match Subst.unify sub neglit plit with
    | Some sub2 -> if !verbose then Format.printf "Reduction works\n%!"; prove sub2 hist (if !cut2 then alt else (fun () -> reduce sub lit1 rest hist alt (todo, prf) neglit pt)) (todo, Pat lit1 :: prf) rest
    | None -> reduce sub lit1 rest hist alt (todo, prf) neglit pt)
  | [] ->
      let dbs = db_entries sub neglit in
      extend sub lit1 rest hist alt (todo, prf) dbs

and extend sub lit1 rest ((path, lem, lim) as hist) alt (todo, prf) = function
  | ((_,_,vars,hsh) as eh) :: et ->
    if !verbose then Format.printf "Extension try %s (for lit %s, lim %d)\n%!" (Hashtbl.find Database.Clausal.no_contr hsh) (string_of_lit lit1) lim;
    (*Format.printf "Contra: %s\n%!" (Hashtbl.find Features.no_contr hsh);*)
    (match if lim <= 0 && vars > 0 then None else Subst.unify_rename sub (snd lit1) eh with
    | Some (sub2, cla1) ->
      if !verbose then Format.printf "Extension works\n%!";
      let hist1 = (path, lit1 :: lem, lim) in
      let ntodo (sub, nalt, prf) = prove sub hist1 (if !cut3 then alt else nalt) (todo, prf) rest in
      incr Stats.infer;
      let hist2 = (lit1 :: path, lem, lim - 1) in
      let step = Res (lit1, path, lem, hsh) in
      prove sub2 hist2 (fun () -> extend sub lit1 rest hist alt (todo, prf) et) (ntodo, step :: prf) cla1
    | None -> extend sub lit1 rest hist alt (todo, prf) et)
  | [] -> alt ()

let start lim = if !verbose then Format.printf "Start %d\n%!" lim; prove
  (Subst.empty 1000000, 0)
  ([], [], lim)
  (fun () -> None)
  ((fun ((sub, off),_,prf) -> Some (Subst.to_list sub, prf)), [])
  [(hash,[])]

let leancop file =
  try
    let load_db conj def = axioms2db (file_mat conj def file) in
    run_schedule load_db start |> Option.map Proof.Clausal.Proof.of_sub_steps |> show_result;
    Stats.print_stats ()
  with e -> print_error e; Stats.print_stats ()

let _ =
  setup_signals ();

  let tosolve = ref [] in
  let speclist = Arg.align Arglean.(Lean.args @ Trace.args) in
  let usage = "Usage: conticop [options] <file.p>\nAvailable options are:" in
  Arg.parse speclist (fun s -> tosolve := s :: !tosolve) usage;

  if !tosolve = [] then Arg.usage speclist usage
  else List.iter leancop (List.rev !tosolve)
