open Batteries
open Printf

type attributes = (string * string) list
type tree = Node of attributes * (attributes * tree) list

let string_of_attributes atts =
  String.concat ", " (List.map (fun (name, value) -> name ^ " = " ^ value) atts)

let rec print_node c pos (Node (node, children)) =
  fprintf c "%s [%s];\n" pos (string_of_attributes node);
  List.iteri (fun i (edge, node') ->
    let pos' = pos ^ string_of_int i in
    fprintf c "%s -> %s [%s];\n" pos pos' (string_of_attributes edge);
    print_node c pos' node') children

let rec print_dot c tree =
  fprintf c "digraph g {\n";
  print_node c "e" tree;
  fprintf c "}\n"
