open Batteries
open Fof
open Term

let subst_axiom eqn isfun (p, arity) =
  let even = List.init arity (fun i -> 2 * i) in
  let odd  = List.map (fun x -> x + 1) even in
  let ovar = List.map (fun x -> V x) odd
  and evar = List.map (fun x -> V x) even in
  let eqs = if isfun
    then List.rev (List.map2 (fun x y -> Atom(eqn, [x; y])) evar ovar)
    else List.rev (List.map2 (fun x y -> Atom(eqn, [x; y])) ovar evar) in
  List.fold_right forall even
   (List.fold_right forall odd
     (List.fold_left (fun sf eq -> Disj (Neg eq, sf))
       (if isfun then (Atom (eqn, [A (p, evar); A (p, ovar)])) else
        Disj (Neg (Atom (p, evar)), Atom (p, ovar))
       ) eqs))

let eq_refl eqn = Forall (1, Atom (eqn, [V 1; V 1]))
let eq_sym eqn =
  Forall (1, Forall (2, Impl (Atom (eqn, [V 1; V 2]), Atom (eqn, [V 2; V 1]))))
let eq_trans eqn = Forall (1, Forall (2, Forall (3, Impl (Conj (Atom (eqn, [V 1; V 2]), Atom (eqn, [V 2; V 3])), Atom (eqn, [V 1; V 3])))))

let eqax1 eqn (fnct, pred) =
  if not (IM.mem eqn pred) then []
  else
    let pred = IM.remove eqn pred in
    let fnax = IM.bindings fnct |> List.map (subst_axiom eqn true)
    and prax = IM.bindings pred |> List.map (subst_axiom eqn false) in
    eq_refl eqn :: eq_sym eqn :: eq_trans eqn :: prax @ fnax

let add_axiom ax = function
    Impl (th, gl) -> Impl (Conj (th, ax), gl)
  | form -> Impl (ax, form)

let equal_axioms eqn form =
  let fp = collect_fp (IM.empty, IM.empty) form in
  match eqax1 eqn fp with
    [] -> form
  | h :: t -> add_axiom (List.fold_left conj h t) form
