################################################################################
# Bushy / 10s / defcnf
################################################################################

out/bushy/10s/defcnf/lazycop-170209-cut: $(BUSHY:bushy/%=\
out/bushy/10s/defcnf/lazycop-170209-cut/%)
out/bushy/10s/defcnf/lazycop-170209-cut/%: cop-170209/lazycop.native bushy/%
	@mkdir -p "`dirname $@`"
	-/usr/bin/time -o "$@.time" timeout 10 $^ \
	  -schedule 0 > "$@"

out/bushy/10s/defcnf/lazycop-170209-nocut: $(BUSHY:bushy/%=\
out/bushy/10s/defcnf/lazycop-170209-nocut/%)
out/bushy/10s/defcnf/lazycop-170209-nocut/%: cop-170209/lazycop.native bushy/%
	@mkdir -p "`dirname $@`"
	-/usr/bin/time -o "$@.time" timeout 10 $^ \
	  -schedule 0 -nocut1 -nocut2 -nocut3 > "$@"


MONTEPARAMS = -exppol cutlit -simdepth 50 -naivereward 1 -mlreward 0

out/bushy/10s/defcnf/montecop-170209: $(BUSHY:bushy/%=\
out/bushy/10s/defcnf/montecop-170209/%)
out/bushy/10s/defcnf/montecop-170209/%: cop-170209/montecop.native bushy/%
	@mkdir -p "`dirname $@`"
	-/usr/bin/time -o "$@.time" timeout 10 $^ \
	  $(MONTEPARAMS) > "$@"

out/bushy/10s/defcnf/montecop-170209-nocut: $(BUSHY:bushy/%=\
out/bushy/10s/defcnf/montecop-170209-nocut/%)
out/bushy/10s/defcnf/montecop-170209-nocut/%: cop-170209/montecop.native bushy/%
	@mkdir -p "`dirname $@`"
	-/usr/bin/time -o "$@.time" timeout 10 $^ \
	  $(MONTEPARAMS) -exppol fst > "$@"

out/bushy/10s/defcnf/montecop-170209-cutcla: $(BUSHY:bushy/%=\
out/bushy/10s/defcnf/montecop-170209-cutcla/%)
out/bushy/10s/defcnf/montecop-170209-cutcla/%: cop-170209/montecop.native bushy/%
	@mkdir -p "`dirname $@`"
	-/usr/bin/time -o "$@.time" timeout 10 $^ \
	  $(MONTEPARAMS) -exppol cutcla > "$@"

out/bushy/10s/defcnf/montecop-170209-constprob: $(BUSHY:bushy/%=\
out/bushy/10s/defcnf/montecop-170209-constprob/%)
out/bushy/10s/defcnf/montecop-170209-constprob/%: cop-170209/montecop.native bushy/%
	@mkdir -p "`dirname $@`"
	-/usr/bin/time -o "$@.time" timeout 10 $^ \
	  $(MONTEPARAMS) -constprob 1 -invprob 0 > "$@"

out/bushy/10s/defcnf/montecop-170209-bayesprob: $(BUSHY:bushy/%=\
out/bushy/10s/defcnf/montecop-170209-bayesprob/%)
out/bushy/10s/defcnf/montecop-170209-bayesprob/%: cop-170209/montecop.native bushy/%
	@mkdir -p "`dirname $@`"
	-/usr/bin/time -o "$@.time" timeout 10 $^ \
	  $(MONTEPARAMS) -bayesprob 1 -invprob 0 \
	  -cdata out/bushy/60s/defcnf/lazycop-170209-md10.cdata > "$@"

out/bushy/10s/defcnf/montecop-170209-randrew: $(BUSHY:bushy/%=\
out/bushy/10s/defcnf/montecop-170209-randrew/%)
out/bushy/10s/defcnf/montecop-170209-randrew/%: cop-170209/montecop.native bushy/%
	@mkdir -p "`dirname $@`"
	-/usr/bin/time -o "$@.time" timeout 10 $^ \
	  $(MONTEPARAMS) -randreward 1 -naivereward 0 > "$@"

out/bushy/10s/defcnf/montecop-170209-sizerew: $(BUSHY:bushy/%=\
out/bushy/10s/defcnf/montecop-170209-sizerew/%)
out/bushy/10s/defcnf/montecop-170209-sizerew/%: cop-170209/montecop.native bushy/%
	@mkdir -p "`dirname $@`"
	-/usr/bin/time -o "$@.time" timeout 10 $^ \
	  $(MONTEPARAMS) -sizereward 1 -naivereward 0 > "$@"

out/bushy/10s/defcnf/montecop-170209-mlrew: $(BUSHY:bushy/%=\
out/bushy/10s/defcnf/montecop-170209-mlrew/%)
out/bushy/10s/defcnf/montecop-170209-mlrew/%: cop-170209/montecop.native bushy/%
	@mkdir -p "`dirname $@`"
	-/usr/bin/time -o "$@.time" timeout 10 $^ \
	  $(MONTEPARAMS) -mlreward 1 -naivereward 0 \
	  -ldata out/bushy/60s/defcnf/lazycop-170209-md10.ldata > "$@"

out/bushy/10s/defcnf/montecop-170209-all: \
  out/bushy/10s/defcnf/lazycop-170209-cut \
  out/bushy/10s/defcnf/lazycop-170209-nocut \
  out/bushy/10s/defcnf/montecop-170209 \
  out/bushy/10s/defcnf/montecop-170209-nocut \
  out/bushy/10s/defcnf/montecop-170209-cutcla \
  out/bushy/10s/defcnf/montecop-170209-constprob \
  out/bushy/10s/defcnf/montecop-170209-bayesprob \
  out/bushy/10s/defcnf/montecop-170209-randrew \
  out/bushy/10s/defcnf/montecop-170209-sizerew \
  out/bushy/10s/defcnf/montecop-170209-mlrew


define bushy-10s-defcnf-montecop-170209-simdepth
out/bushy/10s/defcnf/montecop-170209-simdepth$(SIMDEPTH): $$(BUSHY:bushy/%=\
out/bushy/10s/defcnf/montecop-170209-simdepth$(SIMDEPTH)/%)
out/bushy/10s/defcnf/montecop-170209-simdepth$(SIMDEPTH)/%: cop-170209/montecop.native bushy/%
	@mkdir -p "`dirname $$@`"
	-/usr/bin/time -o "$$@.time" timeout 10 $$^ \
	  $$(MONTEPARAMS) -simdepth $(SIMDEPTH) > "$$@"
endef

SIMDEPTHS=$(shell seq 0 128)
#$(foreach SIMDEPTH,$(SIMDEPTHS),$(eval $(bushy-10s-defcnf-montecop-170209-simdepth)))
out/bushy/10s/defcnf/montecop-170209-simdepths: $(SIMDEPTHS:%=\
out/bushy/10s/defcnf/montecop-170209-simdepth%)


define bushy-10s-defcnf-montecop-170209-maxiters
out/bushy/10s/defcnf/montecop-170209-maxiters$(MAXITERS): $$(BUSHY:bushy/%=\
out/bushy/10s/defcnf/montecop-170209-maxiters$(MAXITERS)/%)
out/bushy/10s/defcnf/montecop-170209-maxiters$(MAXITERS)/%: cop-170209/montecop.native bushy/%
	@mkdir -p "`dirname $$@`"
	-/usr/bin/time -o "$$@.time" timeout 10 $$^ \
	  $$(MONTEPARAMS) -maxiters $(MAXITERS) > "$$@"
endef

MAXITERSS=$(shell seq 0 128)
#$(foreach MAXITERS,$(MAXITERSS),$(eval $(bushy-10s-defcnf-montecop-170209-maxiters)))
out/bushy/10s/defcnf/montecop-170209-maxiterss: $(MAXITERSS:%=\
out/bushy/10s/defcnf/montecop-170209-maxiters%)


define bushy-10s-defcnf-montecop-170209-exploration
out/bushy/10s/defcnf/montecop-170209-exploration$(EXPLORATION): $$(BUSHY:bushy/%=\
out/bushy/10s/defcnf/montecop-170209-exploration$(EXPLORATION)/%)
out/bushy/10s/defcnf/montecop-170209-exploration$(EXPLORATION)/%: cop-170209/montecop.native bushy/%
	@mkdir -p "`dirname $$@`"
	-/usr/bin/time -o "$$@.time" timeout 10 $$^ \
	  $$(MONTEPARAMS) -exploration $(EXPLORATION) > "$$@"
endef

EXPLORATIONS=$(shell LC_NUMERIC=C seq 0 0.1 5)
#$(foreach EXPLORATION,$(EXPLORATIONS),$(eval $(bushy-10s-defcnf-montecop-170209-exploration)))
out/bushy/10s/defcnf/montecop-170209-explorations: $(EXPLORATIONS:%=\
out/bushy/10s/defcnf/montecop-170209-exploration%)


define bushy-10s-defcnf-montecop-170209-mlrew-exploration
out/bushy/10s/defcnf/montecop-170209-mlrew-exploration$(EXPLORATION): $$(BUSHY:bushy/%=\
out/bushy/10s/defcnf/montecop-170209-mlrew-exploration$(EXPLORATION)/%)
out/bushy/10s/defcnf/montecop-170209-mlrew-exploration$(EXPLORATION)/%: cop-170209/montecop.native bushy/%
	@mkdir -p "`dirname $$@`"
	-/usr/bin/time -o "$$@.time" timeout 10 $$^ \
	  $$(MONTEPARAMS) -mlreward 1 -naivereward 0 -exploration $(EXPLORATION) \
	  -ldata out/bushy/60s/defcnf/lazycop-170209-md10.ldata > "$$@"
endef

#$(foreach EXPLORATION,$(EXPLORATIONS),$(eval $(bushy-10s-defcnf-montecop-170209-mlrew-exploration)))
out/bushy/10s/defcnf/montecop-170209-mlrew-explorations: $(EXPLORATIONS:%=\
out/bushy/10s/defcnf/montecop-170209-mlrew-exploration%)




################################################################################
# Bushy / 10s / nodefcnf
################################################################################

out/bushy/10s/lazycop-170209-cut: $(BUSHY:bushy/%=\
out/bushy/10s/lazycop-170209-cut/%)
out/bushy/10s/lazycop-170209-cut/%: cop-170209/lazycop.native bushy/%
	@mkdir -p "`dirname $@`"
	-/usr/bin/time -o "$@.time" timeout 10 $^ -nodefcnf \
	  -schedule 0 > "$@"

out/bushy/10s/lazycop-170209-nocut: $(BUSHY:bushy/%=\
out/bushy/10s/lazycop-170209-nocut/%)
out/bushy/10s/lazycop-170209-nocut/%: cop-170209/lazycop.native bushy/%
	@mkdir -p "`dirname $@`"
	-/usr/bin/time -o "$@.time" timeout 10 $^ -nodefcnf \
	  -schedule 0 -nocut1 -nocut2 -nocut3 > "$@"


MONTEPARAMS = -exppol cutlit -simdepth 50 -naivereward 1 -mlreward 0

out/bushy/10s/montecop-170209-nocut: $(BUSHY:bushy/%=\
out/bushy/10s/montecop-170209-nocut/%)
out/bushy/10s/montecop-170209-nocut/%: cop-170209/montecop.native bushy/%
	@mkdir -p "`dirname $@`"
	-/usr/bin/time -o "$@.time" timeout 10 $^ -nodefcnf \
	  $(MONTEPARAMS) -exppol fst > "$@"

out/bushy/10s/montecop-170209-cutcla: $(BUSHY:bushy/%=\
out/bushy/10s/montecop-170209-cutcla/%)
out/bushy/10s/montecop-170209-cutcla/%: cop-170209/montecop.native bushy/%
	@mkdir -p "`dirname $@`"
	-/usr/bin/time -o "$@.time" timeout 10 $^ -nodefcnf \
	  $(MONTEPARAMS) -exppol cutcla > "$@"

out/bushy/10s/montecop-170209-constprob: $(BUSHY:bushy/%=\
out/bushy/10s/montecop-170209-constprob/%)
out/bushy/10s/montecop-170209-constprob/%: cop-170209/montecop.native bushy/%
	@mkdir -p "`dirname $@`"
	-/usr/bin/time -o "$@.time" timeout 10 $^ -nodefcnf \
	  $(MONTEPARAMS) -constprob 1 -invprob 0 > "$@"

out/bushy/10s/montecop-170209-bayesprob: $(BUSHY:bushy/%=\
out/bushy/10s/montecop-170209-bayesprob/%)
out/bushy/10s/montecop-170209-bayesprob/%: cop-170209/montecop.native bushy/%
	@mkdir -p "`dirname $@`"
	-/usr/bin/time -o "$@.time" timeout 10 $^ -nodefcnf \
	  $(MONTEPARAMS) -bayesprob 1 -invprob 0 \
	  -cdata out/bushy/60s/lazycop-170207-ndc-md10.cdata > "$@"

out/bushy/10s/montecop-170209-randrew: $(BUSHY:bushy/%=\
out/bushy/10s/montecop-170209-randrew/%)
out/bushy/10s/montecop-170209-randrew/%: cop-170209/montecop.native bushy/%
	@mkdir -p "`dirname $@`"
	-/usr/bin/time -o "$@.time" timeout 10 $^ -nodefcnf \
	  $(MONTEPARAMS) -randreward 1 -naivereward 0 > "$@"

out/bushy/10s/montecop-170209-sizerew: $(BUSHY:bushy/%=\
out/bushy/10s/montecop-170209-sizerew/%)
out/bushy/10s/montecop-170209-sizerew/%: cop-170209/montecop.native bushy/%
	@mkdir -p "`dirname $@`"
	-/usr/bin/time -o "$@.time" timeout 10 $^ -nodefcnf \
	  $(MONTEPARAMS) -sizereward 1 -naivereward 0 > "$@"

out/bushy/10s/montecop-170209-mlrew: $(BUSHY:bushy/%=\
out/bushy/10s/montecop-170209-mlrew/%)
out/bushy/10s/montecop-170209-mlrew/%: cop-170209/montecop.native bushy/%
	@mkdir -p "`dirname $@`"
	-/usr/bin/time -o "$@.time" timeout 10 $^ -nodefcnf \
	  $(MONTEPARAMS) -mlreward 1 -naivereward 0 \
	  -ldata out/bushy/60s/lazycop-170207-ndc-md10.ldata > "$@"

define montecop-170209-simdepth
out/bushy/10s/montecop-170209-simdepth$(SIMDEPTH): $$(BUSHY:bushy/%=\
out/bushy/10s/montecop-170209-simdepth$(SIMDEPTH)/%)
out/bushy/10s/montecop-170209-simdepth$(SIMDEPTH)/%: cop-170209/montecop.native bushy/%
	@mkdir -p "`dirname $$@`"
	-/usr/bin/time -o "$$@.time" timeout 10 $$^ -nodefcnf \
	  $$(MONTEPARAMS) -simdepth $(SIMDEPTH) > "$$@"
endef

SIMDEPTHS=$(shell seq 0 64)
#$(foreach SIMDEPTH,$(SIMDEPTHS),$(eval $(montecop-170209-simdepth)))
out/bushy/10s/montecop-170209-simdepths: $(SIMDEPTHS:%=out/bushy/10s/montecop-170209-simdepth%)

define montecop-170209-maxiters
out/bushy/10s/montecop-170209-maxiters$(MAXITERS): $$(BUSHY:bushy/%=\
out/bushy/10s/montecop-170209-maxiters$(MAXITERS)/%)
out/bushy/10s/montecop-170209-maxiters$(MAXITERS)/%: cop-170209/montecop.native bushy/%
	@mkdir -p "`dirname $$@`"
	-/usr/bin/time -o "$$@.time" timeout 10 $$^ -nodefcnf \
	  $$(MONTEPARAMS) -maxiters $(MAXITERS) > "$$@"
endef

MAXITERSS=$(shell seq 0 128)
#$(foreach MAXITERS,$(MAXITERSS),$(eval $(montecop-170209-maxiters)))
out/bushy/10s/montecop-170209-maxiterss: $(MAXITERSS:%=out/bushy/10s/montecop-170209-maxiters%)

define montecop-170209-exploration
out/bushy/10s/montecop-170209-exploration$(EXPLORATION): $$(BUSHY:bushy/%=\
out/bushy/10s/montecop-170209-exploration$(EXPLORATION)/%)
out/bushy/10s/montecop-170209-exploration$(EXPLORATION)/%: cop-170209/montecop.native bushy/%
	@mkdir -p "`dirname $$@`"
	-/usr/bin/time -o "$$@.time" timeout 10 $$^ -nodefcnf \
	  $$(MONTEPARAMS) -exploration $(EXPLORATION) > "$$@"
endef

EXPLORATIONS=$(shell LC_NUMERIC=C seq 0 0.1 2)
#$(foreach EXPLORATION,$(EXPLORATIONS),$(eval $(montecop-170209-exploration)))
out/bushy/10s/montecop-170209-explorations: $(EXPLORATIONS:%=out/bushy/10s/montecop-170209-exploration%)


data/montecop-170209-%:
	@mkdir -p "`dirname $@`"
	wc -l solved/bushy/10s/* | sed -n 's/\s*\([0-9]*\)\s.*$*\(.*\)/\2 \1/p' | sort -n > $@

# monteCoP:
# - attenuation of previously used cps?
