################################################################################
# Bushy / 60s / defcnf
################################################################################

out/bushy/60s/defcnf/lazycop-170209-md10.ldata: out/bushy/60s/defcnf/lazycop-170209-md10 cop-170209/accumstats.native
	cat $</*.trace | cop-170209/accumstats.native > $@

out/bushy/60s/defcnf/lazycop-170209-md10.cdata: out/bushy/60s/defcnf/lazycop-170209-md10 cop-170209/hasher.native
	cop-170209/hasher.native out/bushy/60s/defcnf/lazycop-170209-md10/*.p -o $@

out/bushy/60s/defcnf/lazycop-170209-md10: $(BUSHY:bushy/%=out/bushy/60s/defcnf/lazycop-170209-md10/%)
out/bushy/60s/defcnf/lazycop-170209-md10/%: cop-170209/lazycop.native bushy/%
	@mkdir -p "`dirname $@`"
	-/usr/bin/time -o "$@.time" timeout 60 $^ -trace "$@.trace" -maxdepth 10 -mlproof > "$@"



################################################################################
# Bushy / 60s / nodefcnf
################################################################################

out/bushy/60s/nodefcnf/leancop-150530-nilearn: $(BUSHY:bushy/%=\
out/bushy/60s/nodefcnf/leancop-150530-nilearn/%)
out/bushy/60s/nodefcnf/leancop-150530-nilearn/%: cop-150530/leancop bushy/%
	@mkdir -p "`dirname $@`"
	-/usr/bin/time -o "$@.time" timeout 60 $^ -nodef -learn > "$@"

out/bushy/60s/nodefcnf/leancop-150530-dt: $(BUSHY:bushy/%=\
out/bushy/60s/nodefcnf/leancop-150530-dt/%)
out/bushy/60s/nodefcnf/leancop-150530-dt/%: cop-150530/leancop bushy/%
	@mkdir -p "`dirname $@`"
	-/usr/bin/time -o "$@.time" timeout 60 $^ -nodef -dtree > "$@"

out/bushy/60s/nodefcnf/leancop-150530: $(BUSHY:bushy/%=\
out/bushy/60s/nodefcnf/leancop-150530/%)
out/bushy/60s/nodefcnf/leancop-150530/%: cop-150530/leancop bushy/%
	@mkdir -p "`dirname $@`"
	-/usr/bin/time -o "$@.time" timeout 60 $^ -nodef > "$@"



################################################################################
# Bushy / 60s
################################################################################

out/bushy/60s/montecop-170207-sr1: $(BUSHY:bushy/%=out/bushy/60s/montecop-170207-sr1/%)
out/bushy/60s/montecop-170207-sr1/%: cop-170207/montecop.native bushy/%
	@mkdir -p "`dirname $@`"
	-/usr/bin/time -o "$@.time" timeout 60 $^ \
	  -nodefcnf -mlreward 0 -sizereward 1 > "$@"

out/bushy/60s/montecop-170207-mr1: $(BUSHY:bushy/%=out/bushy/60s/montecop-170207-mr1/%)
out/bushy/60s/montecop-170207-mr1/%: cop-170207/montecop.native bushy/%
	@mkdir -p "`dirname $@`"
	-/usr/bin/time -o "$@.time" timeout 60 $^ \
	  -nodefcnf -ldata out/bushy/60s/lazycop-170207-ndc-md10.ldata \
	  -mlreward 1 -naivereward 0 > "$@"

out/bushy/60s/montecop-170207-ip1-nr1: $(BUSHY:bushy/%=out/bushy/60s/montecop-170207-ip1-nr1/%)
out/bushy/60s/montecop-170207-ip1-nr1/%: cop-170207/montecop.native bushy/%
	@mkdir -p "`dirname $@`"
	-/usr/bin/time -o "$@.time" timeout 60 $^ \
	  -nodefcnf -invprob 1 -mlreward 0 -naivereward 1 > "$@"

out/bushy/60s/montecop-170207-bp.3-ip.7-nr1: $(BUSHY:bushy/%=out/bushy/60s/montecop-170207-bp.3-ip.7-nr1/%)
out/bushy/60s/montecop-170207-bp.3-ip.7-nr1/%: cop-170207/montecop.native bushy/%
	@mkdir -p "`dirname $@`"
	-/usr/bin/time -o "$@.time" timeout 60 $^ \
	  -nodefcnf -cdata out/bushy/60s/lazycop-170207-ndc-md10.cdata \
	  -bayesprob 0.3 -invprob 0.7 -mlreward 0 -naivereward 1 > "$@"

out/bushy/60s/montecop-170207-bp.1-ip.9-nr1: $(BUSHY:bushy/%=out/bushy/60s/montecop-170207-bp.1-ip.9-nr1/%)
out/bushy/60s/montecop-170207-bp.1-ip.9-nr1/%: cop-170207/montecop.native bushy/%
	@mkdir -p "`dirname $@`"
	-/usr/bin/time -o "$@.time" timeout 60 $^ \
	  -nodefcnf -cdata out/bushy/60s/lazycop-170207-ndc-md10.cdata \
	  -bayesprob 0.1 -invprob 0.9 -mlreward 0 -naivereward 1 > "$@"

out/bushy/60s/lazycop-170207-ndc-md10.ldata: out/bushy/60s/lazycop-170207-ndc-md10 cop-170207/accumstats.native
	cat $</*.trace | cop-170207/accumstats.native > $@

out/bushy/60s/lazycop-170207-ndc-md10.cdata: out/bushy/60s/lazycop-170207-ndc-md10 cop-170207/hasher.native
	cop-170207/hasher.native out/bushy/60s/lazycop-170207-ndc-md10/*.p -o $@

out/bushy/60s/lazycop-170207-ndc-md10: $(BUSHY:bushy/%=out/bushy/60s/lazycop-170207-ndc-md10/%)
out/bushy/60s/lazycop-170207-ndc-md10/%: cop-170207/lazycop.native bushy/%
	@mkdir -p "`dirname $@`"
	-/usr/bin/time -o "$@.time" timeout 60 $^ -trace "$@.trace" -nodefcnf -maxdepth 10 -mlproof > "$@"

out/bushy/60s/leancop-151223-nilearn: $(BUSHY:bushy/%=out/bushy/60s/leancop-151223-nilearn/%)
out/bushy/60s/leancop-151223-nilearn/%: cop-151223/leancop bushy/%
	@mkdir -p "`dirname $@`"
	-time -o "$@.time" timeout 60 $^ -learn > "$@"

out/bushy/60s/leancop-151223: $(BUSHY:bushy/%=out/bushy/60s/leancop-151223/%)
out/bushy/60s/leancop-151223/%: cop-151223/leancop bushy/%
	@mkdir -p "`dirname $@`"
	-time -o "$@.time" timeout 60 $^ > "$@"

out/bushy/60s/leancop-151223-nd-fns-dt-learn: $(BUSHY:bushy/%=out/bushy/60s/leancop-151223-nd-fns-dt-learn/%)
out/bushy/60s/leancop-151223-nd-fns-dt-learn/%: out/bushy/60s/leancop-151223-nd-fns.datai cop-151223/leancop bushy/%
	@mkdir -p "`dirname $@`"
	-time -o "$@.time" timeout 60 $(filter-out $<,$^) -nodef -feanosubst -dtree -datai $< -learn > "$@"

out/bushy/60s/leancop-151223-nd-fns-learn: $(BUSHY:bushy/%=out/bushy/60s/leancop-151223-nd-fns-learn/%)
out/bushy/60s/leancop-151223-nd-fns-learn/%: out/bushy/60s/leancop-151223-nd-fns.datai cop-151223/leancop bushy/%
	@mkdir -p "`dirname $@`"
	-time -o "$@.time" timeout 60 $(filter-out $<,$^) -nodef -feanosubst -datai $< -learn > "$@"

out/bushy/60s/leancop-151223-nd-learn: $(BUSHY:bushy/%=out/bushy/60s/leancop-151223-nd-learn/%)
out/bushy/60s/leancop-151223-nd-learn/%: out/bushy/60s/leancop-151223-nd.datai cop-151223/leancop bushy/%
	@mkdir -p "`dirname $@`"
	-time -o "$@.time" timeout 60 $(filter-out $<,$^) -nodef -datai $< -learn > "$@"

out/bushy/60s/leancop-151223-nd.data: out/bushy/60s/leancop-151223-nd
	cat $</*.p > $@

out/bushy/60s/leancop-151223-nd-fns.datai: cop-151223/hasher out/bushy/60s/leancop-151223-nd.data
	$(call hasher-wrap,-feanosubst)

out/bushy/60s/leancop-151223-nd.datai: cop-151223/hasher out/bushy/60s/leancop-151223-nd.data
	$(hasher-wrap)

out/bushy/60s/leancop-151223-nd-dt: $(BUSHY:bushy/%=out/bushy/60s/leancop-151223-nd-dt/%)
out/bushy/60s/leancop-151223-nd-dt/%: cop-151223/leancop bushy/%
	@mkdir -p "`dirname $@`"
	-time -o "$@.time" timeout 60 $^ -nodef -dtree > "$@"

out/bushy/60s/leancop-151223-nd: $(BUSHY:bushy/%=out/bushy/60s/leancop-151223-nd/%)
out/bushy/60s/leancop-151223-nd/%: cop-151223/leancop bushy/%
	@mkdir -p "`dirname $@`"
	-time -o "$@.time" timeout 60 $^ -nodef > "$@"

out/bushy/60s/leancop-160211-nd-learn: $(BUSHY:bushy/%=out/bushy/60s/leancop-160211-nd-learn/%)
out/bushy/60s/leancop-160211-nd-learn/%: out/bushy/60s/leancop-160211-nd.datai cop-160211/leancop bushy/%
	@mkdir -p "`dirname $@`"
	-time -o "$@.time" timeout 60 $(filter-out $<,$^) -nodef -datai $< -learn > "$@"

out/bushy/60s/leancop-160211-nd.data: out/bushy/60s/leancop-160211-nd
	cat $</*.p > $@

out/bushy/60s/leancop-160211-nd.datai: cop-160211/hasher out/bushy/60s/leancop-160211-nd.data
	$(hasher-wrap)

out/bushy/60s/leancop-160211-nd: $(BUSHY:bushy/%=out/bushy/60s/leancop-160211-nd/%)
out/bushy/60s/leancop-160211-nd/%: cop-160211/leancop bushy/%
	@mkdir -p "`dirname $@`"
	-time -o "$@.time" timeout 60 $^ -nodef > "$@"

out/bushy/60s/leancop-160211-learn: $(BUSHY:bushy/%=out/bushy/60s/leancop-160211-learn/%)
out/bushy/60s/leancop-160211-learn/%: out/bushy/60s/leancop-160211.datai cop-160211/leancop bushy/%
	@mkdir -p "`dirname $@`"
	-time -o "$@.time" timeout 60 $(filter-out $<,$^) -datai $< -learn > "$@"

out/bushy/60s/leancop-160211.data: out/bushy/60s/leancop-160211
	cat $</*.p > $@

out/bushy/60s/leancop-160211.datai: cop-160211/hasher out/bushy/60s/leancop-160211.data
	$(hasher-wrap)

out/bushy/60s/leancop-160211: $(BUSHY:bushy/%=out/bushy/60s/leancop-160211/%)
out/bushy/60s/leancop-160211/%: cop-160211/leancop bushy/%
	@mkdir -p "`dirname $@`"
	-time -o "$@.time" timeout 60 $^ > "$@"
