# input files (FOF/CNF TPTP files contain either + or - in filename)
TPTP  = $(shell find tptp/ -type f -regex ".*\(\+\|-\).*\.p" | sort -R)
MIZAR = $(shell find mizar/ -type f | sort -R)
TRAIN = $(shell awk '{print "bushy/" $$0}' mzrturing100/train.files | sort -R)
TEST  = $(shell awk '{print "bushy/" $$0}' mzrturing100/test.files  | sort -R)
BUSHY = $(shell find bushy/ -type f | sort -R)

TPTP-%.tgz:
	wget http://www.cs.miami.edu/~tptp/TPTP/Archive/TPTP-$*/$@

TPTP-%: TPTP-%.tgz
	tar xzf $<

puz: TPTP-v6.3.0
	ln -s $</Problems/PUZ $@

tptp4X: TPTP-v6.3.0
	ln -s $</Scripts/tptp4X $@


MPTP2078:
	git clone https://github.com/JUrban/$@ && cd $@ && git checkout bc58295

bushy: MPTP2078
	ln -s $</$@

fof/%: tptp/%
	@mkdir -p "`dirname $@`"
	./tptp4X -x -t fofify "$<" > "$@"
