import Data.List (maximumBy, delete)
import Data.Ord (comparing)
import Data.Set (Set)
import qualified Data.Set as Set
import System.Environment (getArgs)

greedy :: (Ord a, Eq t) => Set a -> [(t, Set a)] -> [(t, Int)]
greedy elems [] = []
greedy elems sets =
  let sets' = map (\ (name, set) -> (name, Set.difference set elems)) sets
      (name, set) = maximumBy (comparing (Set.size . snd)) sets'
  in  (name, Set.size set) : greedy (Set.union elems set) (delete (name, set) sets')

sumDiffs = reverse . fst .
  foldl (\ (prev, sum) (name, diff) -> ((name, diff, sum+diff) : prev, sum+diff)) ([], 0)

main =
  getArgs >>=
  mapM (\ fp -> readFile fp >>= \ f -> return (fp, Set.fromList (lines f))) >>=
  return . sumDiffs . greedy Set.empty >>=
  mapM print
