import Control.Monad
import Data.List
import Data.Ord
import System.Process
import Text.Printf

optimise evaluate = foldM go where
  go prev vs = do
    results <- mapM (\ v -> evaluate (prev ++ [v]) >>= return . (,) v) vs
    return (prev ++ [fst (maximumBy (comparing snd) results)])

eval :: [String] -> IO Int
eval args = readProcess "./testy.sh" args [] >>= return . read

combine p vs = [p ++ " " ++ v | v <- vs]

show1f :: Double -> String
show1f = printf "%.1f"

flags =
  [ combine "-mlmean" ["min", "prod", "harm", "geom", "arit"]
  , combine "-cert" (map show1f [0.7, 0.8 .. 1.0])
  , combine "-certdamp" (map show [1 .. 4])
  , combine "-defscore" (map show1f [0.6, 0.7 .. 0.9])
  , combine "-naivereward" (map show1f [0.0, 0.1 .. 0.5])
  , combine "-exploration" (map show1f [0.7, 0.8 .. 1.0])
  , combine "-maxiters" (map show [20 .. 40])
  , combine "-simdepth" (map show [20 .. 30])
  ]

initial = []

main = optimise eval initial flags >>= putStrLn . unwords
