#!/bin/bash
FILE=$1
FILEINFO=$2
TIMEOUT=$3
MAXINFS=$4
SEED=$5
PARAMS="${@:6}"
echoerr() { echo "$@" 1>&2; }
echoerr Filename: $FILE
echoerr Timeout: $TIMEOUT
echoerr Maximal inferences: $MAXINFS
echoerr Seed: $SEED
echoerr Parameters: $PARAMS

#sleep 1
#set -o xtrace

MAX=10000000
OUT=`mktemp`
/usr/bin/time -o "$OUT.time" timeout $TIMEOUT ../cop-161005/montecop.native -data montecop-161005/training.data $FILE -maxinfs $MAXINFS -seed $SEED $PARAMS > "$OUT"
if grep -q Theorem $OUT; then
  STATUS=Theorem
  #BESTSOL=`cat $OUT | wc -l`
  INFS=`grep "% Inf:" $OUT | cut -f 3 -d " "`
else
  STATUS=Timeout
  INFS=$MAX
fi
BESTSOL=$MAX
RUNTIME=`grep elapsed "$OUT.time" | cut -f 1 -d "u"`
rm "$OUT" "$OUT.time"

echo Result for ParamILS: $STATUS, $RUNTIME, $INFS, $BESTSOL, $SEED
