#!/bin/bash
FILE=$1
FILEINFO=$2
TIMEOUT=$3
MAXINFS=$4
SEED=$5
PARAMS="${@:6}"
echoerr() { echo "$@" 1>&2; }
echoerr Filename: $FILE
echoerr Timeout: $TIMEOUT
echoerr Seed: $SEED
echoerr Parameters: $PARAMS

#sleep 1
#set -o xtrace

MAX=10000000
OUT=`mktemp`

/usr/bin/time -o "$OUT.time" timeout $TIMEOUT ../cop-161230-ti/montecop.native \
  -ldata ../out/mzrtrain/300s/lazycop-161221-md10.ldata \
  -cdata ../out/mzrtrain/300s/lazycop-161221-md10.cdata \
  $FILE -seed $SEED $PARAMS > "$OUT"

if grep -q Theorem $OUT; then
  STATUS=Theorem
  #BESTSOL=`cat $OUT | wc -l`
  INFS=`grep "% Inf:" $OUT | awk '{print $3+$7}'`
else
  STATUS=Timeout
  INFS=$MAX
fi
BESTSOL=$MAX
RUNTIME=`grep elapsed "$OUT.time" | cut -f 1 -d "u"`
rm "$OUT" "$OUT.time"

echo Result for ParamILS: $STATUS, $RUNTIME, $INFS, $BESTSOL, $SEED
