#!/bin/bash
set -e

ARGS="$*"
CARGS=`echo $ARGS | sed 's/ /,/g'`
FILE=montecop-170209$CARGS
TARGET=out/bushy/10s/defcnf/optimise/$FILE

(>&2 echo Current configuration: $ARGS)

echo -e "
include cop.mk datasets.mk
$TARGET: \$(BUSHY:bushy/%=\
$TARGET/%)
$TARGET/%: cop-170209/montecop.native bushy/%
	@mkdir -p \`dirname \$@\`
	-/usr/bin/time -o \$@.time timeout 10 $^ \\
          -ldata out/bushy/60s/defcnf/lazycop-170209-md10.ldata \\
	  -exppol cutcla \\
          $ARGS > \$@
" > $FILE.mk

make -j40 -f $FILE.mk $TARGET > $FILE.log 2>&1

SOLVED=`(cd $TARGET && grep -l Theorem *) | wc -l`
(>&2 echo Solved: $SOLVED)
echo $SOLVED
#echo $RANDOM
