open Matrix.Nonclausal

type 'v litmat_ext =
    (* beta clause, whole clause *)
    Litext of ('v clause * 'v clause) * 'v clause
    (* matrix index, surrounding clause, path in clause *)
  | Matext of int * ('v clause * 'v clause) * 'v clause_ext
(* clause index, surrounding matrix, path in litmat *)
and 'v clause_ext = (int * 'v list) * ('v matrix * 'v matrix) * 'v litmat_ext

let offset_iv off (i, v) = (i, List.map ((+) off) v)
let map2 f (x, y) = f x, f y

let rec offset_litmat_ext off = function
    Litext (claB, claC) ->
      Litext (map2 (offset_clause off) claB, offset_clause off claC)
  | Matext (j, claLR, clext) ->
      Matext (j, map2 (offset_clause off) claLR, offset_clause_ext off clext)
and offset_clause_ext off (iv, matLR, lmext) =
  offset_iv off iv, map2 (offset_matrix off) matLR, offset_litmat_ext off lmext

let rec claBC_of_litmat_ext = function
    Litext ((claL, claR), claC) -> (List.rev_append claL claR, claC)
  | Matext (j, (claL, claR), clext) ->
      let claB, claC = claBC_of_clause_ext clext in
      Mat (j, claB) :: List.rev_append claL claR,
      Mat (j, claC) :: List.rev_append claL claR
and claBC_of_clause_ext (iv, (matL, matR), lmext) =
  let claB, claC = claBC_of_litmat_ext lmext in
  [iv, claB], (iv, claC) :: List.rev_append matL matR


let list_rest l =
  let rec go acc = function
    x :: xs -> (x, (acc, xs)) :: go (x :: acc) xs
  | [] -> [] in
  go [] l

let concat_map f l = List.concat (List.map f l)

let rec assert_iclause matLR (iv, (c : 'a clause)) =
  if !Arglean.Trace.verbose then Format.printf "Asserting clause %s.\n%!" (Print.string_of_nclause c);
  list_rest c |> concat_map (fun (lm, claLR) ->
    map_litmat
      (fun lit -> [(lit, 1 + clause_max_var (-1) c), Litext (claLR, c)])
      (assert_imatrix claLR) lm)
    |> List.map (fun (lit, lmext) -> lit, (iv, matLR, lmext))
and assert_imatrix claLR (j, mat) =
  list_rest mat |> concat_map (fun (cla, matLR) -> assert_iclause matLR cla)
    |> List.map (fun (lit, claext) -> lit, Matext (j, claLR, claext))

let assert_matrix = concat_map (assert_iclause ([], []))

