open Batteries
open Term
open Mapping
open Cnf
open Arglean.Female
open Arglean.Lean
open Arglean.Feats
open Features
open Database.Clausal.ClassifierDb
open Common
open Print
open Proof.Clausal.Step

module Subst = Substitution.Substoff (Substitution.Substarray)

let print_nclause (subst, _) clause = print_clause clause
let print_clause (subst, _) clause = print_clause (List.map (Subst.inst_lit subst) clause)

let rec prove sub hist alt (todo, prf) = function
  | [] -> todo (sub, alt, prf)
  | (lit1 :: rest as cl) ->
     let (path, fea, lem, lim) = hist in
     (*  print_clause sub (lit1 :: rest); Format.print_string "\t\t"; print_clause sub (List.rev path); Format.print_char '\n';
     print_nclause sub (lit1 :: rest); Format.print_string "\t\t"; print_nclause sub (List.rev path); Format.print_char '\n';*)
     if (List.exists (fun x -> List.exists (Subst.eq sub x) path)) cl then alt () else
     if List.exists (Subst.eq sub lit1) lem then
       prove sub hist (if !cut1 then alt else (fun () -> reduce sub lit1 rest hist alt (todo, prf) (negate_lit lit1) path)) (todo, Lem lit1 :: prf) rest
     else reduce sub lit1 rest hist alt (todo, prf) (negate_lit lit1) path

and reduce sub lit1 rest hist alt (todo, prf) neglit = function
  | plit :: pt -> (match Subst.unify sub neglit plit with
    | Some sub2 -> prove sub2 hist (if !cut2 then alt else (fun () -> reduce sub lit1 rest hist alt (todo, prf) neglit pt)) (todo, Pat lit1 :: prf) rest
    | None -> reduce sub lit1 rest hist alt (todo, prf) neglit pt)
  | [] ->
      let (path,fea,lem,lim) = hist in
      let nfea = if !upd_fea then update_features (fst sub |> Subst.to_list) lit1 fea else fea in
      let hist = path, nfea, lem, lim in
      let dbs = db_entries sub neglit in
      let dbs = relevancel nfea dbs in
      extend sub lit1 rest hist alt (todo, prf) dbs

and extend sub lit1 rest ((path, fea, lem, lim) as hist) alt (todo, prf) = function
  | (((_,_,vars,hsh) as eh), chwei) :: et ->
    (match if lim <= 0 && vars > 0 then None else Subst.unify_rename sub (snd lit1) eh with
    | Some (sub2, cla1) ->
      let hist1 = (path, fea, lit1 :: lem, lim) in
      let ntodo (sub, nalt, prf) = prove sub hist1 (if !cut3 then alt else nalt) (todo, prf) rest in
      incr Stats.infer;
      let hist2 = (lit1 :: path, fea, lem, lim - chwei) in
      let step = Res (lit1, path, lem, hsh) in
      prove sub2 hist2 (fun () -> extend sub lit1 rest hist alt (todo, prf) et) (ntodo, step :: prf) cla1
    | None -> extend sub lit1 rest hist alt (todo, prf) et)
  | [] -> alt ()

let start lim = prove
  (Subst.empty 1000000, 0)
  ([], FM.empty, [], lim)
  (fun () -> None)
  ((fun ((sub, off),_,prf) -> Some (Subst.to_list sub, prf)), [])
  [(hash,[])]

let leancop file =
  try
    let load_db conj def = axioms2db !classifier (file_mat conj def file) in
    run_schedule load_db start |> Option.map Proof.Clausal.Proof.of_sub_steps |> show_result;
    Stats.print_stats ()
  with e -> print_error e; Stats.print_stats ()

let _ =
  setup_signals ();

  let tosolve = ref [] in
  let speclist = Arg.align Arglean.(Female.args @ Lean.args @ Feats.args) in
  let usage = "Usage: femalecop [options] <file.p>\nAvailable options are:" in
  Arg.parse speclist (fun s -> tosolve := s :: !tosolve) usage;

  if !do_nbayes then classifier := FClassifier.load (!cdata);

  if !tosolve = [] then Arg.usage speclist usage
  else List.iter leancop (List.rev !tosolve)
