%{
  open Mapping
  open Fof
  open Term

  let is_uppercase s = s <> "" && s.[0] <> Char.lowercase s.[0]
%}

%token <string> Word
%token <string list> All Ex
%token Eof Openp Closep Dot Comma Eq Neq Not Impl Revimpl Eqvt Neqvt And Or

%right Impl
%nonassoc Eqvt
%nonassoc Eq Neq
%left Or
%left And
%nonassoc Not
%nonassoc All Exists

%start fof_top fof_data
%type <(string * string * Fof.sform)> fof_top
%type <(Fof.sform * Fof.sform * Fof.sform list * Fof.sform list * Fof.sform * Fof.sform list * Fof.sform list)> fof_data
%%

fof_top :
  Word Openp Word Comma Word Comma formula Closep Dot { ($3, $5, $7) }
| Eof { raise End_of_file };

qformula :
  Openp formula Closep { $2 }
| Word { pred $1 [] }
| Word Openp ts { pred $1 $3 }
| fterm Eq  fterm { Atom (eqn, [$1; $3]) }
| fterm Neq fterm { Neg (Atom (eqn, [$1; $3])) }
| Not qformula { Neg $2 }
| All qformula { List.fold_right forall $1 $2 }
| Ex  qformula { List.fold_right exists $1 $2 }

formula :
  qformula     { $1 }
| formula Impl    formula { Impl ($1, $3) }
| formula Revimpl formula { Impl ($3, $1) }
| formula Eqvt formula  { Eqiv ($1, $3) }
| formula Neqvt formula { Neg (Eqiv ($1, $3)) }
| formula And formula { Conj ($1, $3) }
| formula Or formula { Disj ($1, $3) }

fterm :
  Word { if is_uppercase $1 then V $1 else const $1 [] }
| Word Openp ts { const $1 $3 }

ts :
  fterm Comma ts { $1 :: $3 }
| fterm Closep   { [$1] };

flist :
  formula Comma flist  { $1 :: $3 }
| formula Closep { [$1] }
| Closep { [] };

fof_data :
  formula Comma Openp formula Closep Comma Openp flist Comma Openp flist
          Comma Openp formula Closep Comma Openp flist Comma Openp flist
          Dot { ($1, $4, $8, $11, $14, $18, $21) }
| Eof { raise End_of_file };
