open Mapping
open Fof_parse
open Features
open Classifier
open Arglean.Feats
open Arglean.IO

let training_ex (co, lpl, nlpl) =
  let lit, pat, lem = if !fea_undersubst then lpl else nlpl in
  path_features [] (lit :: pat), Database.form_hash (Fof.unfold_equiv true co)

let conv_int (co, lit, pat, lem, nlit, npat, nlem) =
  let f = Fof.map_form_vars var in
  let fs = List.map f in
  f co, (f lit, fs pat, fs lem), (f nlit, fs npat, fs nlem)

let _ =
  let tohash = ref [] in
  let speclist = Arg.align Arglean.(Feats.args @ IO.args) in
  let usage = "Usage: hasher [OPTION]... [FILE]...\nAvailable options are:" in
  Arg.parse speclist (fun s -> tohash := s :: !tohash) usage;

  (* read new, unhashed data *)
  let l = List.concat (List.map (fun s -> List.map conv_int (Fof_lexer.data_file s)) !tohash) in
  Printf.printf "Read %d proof files\n%!" (List.length !tohash);

  let classifier = if !infile = "" then FClassifier.empty () else FClassifier.load !infile in
  FClassifier.add_training_exs classifier (List.map training_ex l);
  if !outfile = "" then Format.eprintf "No output file given; no file written.\n%!"
  else FClassifier.write classifier !outfile;
