(*
module Lazylist =
struct
*)

type 'x t = unit -> 'x node_t
and 'x node_t = Nil | Cons of ('x * 'x t)

let nil () = Nil
let cons x xs () = Cons (x, xs)

let next xs = xs ()

let rec of_list xs () = match xs with
    [] -> Nil
  | x :: xs -> Cons(x, of_list xs)

let rec to_list xs = match xs () with
    Nil -> []
  | Cons (x, xs) -> x :: to_list xs

let peek xs = match xs () with
    Nil -> None
  | Cons (x, _) -> Some x

let rec map f xs () = match xs () with
    Nil -> Nil
  | Cons (x, xs) -> Cons (f x, map f xs)

let append (l1 : 'a t) (l2 : 'a t) =
  let rec aux l () = match l () with
      Cons (x, (t : 'a t)) -> Cons (x, aux t)
    | _                    -> l2 ()
  in aux l1

let rec filter_map f xs () = match xs () with
    Nil -> Nil
  | Cons (x, xs) -> (match f x with
        None -> filter_map f xs ()
      | Some y -> Cons (y, filter_map f xs))

let rec exists p xs = match xs () with
    Nil -> false
  | Cons (x, xs) -> if p x then true else exists p xs

let lazy_fold_right f l init =
  let rec aux rest () =
    match rest () with
    | Cons (x, t) -> f x (aux t)
    | Nil -> init ()
  in aux l

let concat lol =
  lazy_fold_right (fun li rest -> append li rest ()) lol nil

let rec length xs = match xs () with
    Nil -> 0
  | Cons (x, xs) -> 1 + length xs

(*
end
*)
