open Batteries
open Arglean.Trace

(* clause, literal, positive & negative occurrences *)
let cl_in  : (int, (int * (int * int)) list) Hashtbl.t = Hashtbl.create 10000
let cl_out : (int, (int * (int * int)) list) Hashtbl.t = Hashtbl.create 1000

let add2 (x1, y1) (x2, y2) = (x1 + x2, y1 + y2)

let add_pn data cl lit pn =
  Hashtbl.modify_def [] cl (List.modify_def (0,0) lit (add2 pn)) data

let add_line data line =
  try Scanf.sscanf line "%d\t%d\t%d\t%d"
    (fun p n lit cl -> add_pn data cl lit (p, n))
  with End_of_file -> Format.eprintf "unmatched line: %s\n" line
let add_data data = Enum.iter (add_line data)
let add_cl_in = add_data cl_in

let print_data data c =
  Hashtbl.iter (fun cl -> List.iter (fun (lit, (p, n)) -> Printf.fprintf c "%d\t%d\t%d\t%d\n" p n lit cl)) data
let print_cl_out = print_data cl_out

let trace_proofs lit cl_hsh prfs =
  if !trace_file = "" then prfs
  else
    let lit_hsh = Database.lit_hash lit in
    let pn = if Option.is_some (LazyList.peek prfs) then 1,0 else 0,1 in
    add_pn cl_out cl_hsh lit_hsh pn;
    prfs

let write_trace prf =
  if !trace_file <> "" then File.with_file_out !trace_file print_cl_out; prf
