open Batteries

let add2 (x1, y1) (x2, y2) = (x1 + x2, y1 + y2)

let () =
  let sym_max = ref 0 in
  let sym_no, no_sym = Hashtbl.create 10000, Hashtbl.create 10000 in
  let get_symno tbl sym =
    try Hashtbl.find tbl sym
    with Not_found -> Hashtbl.add tbl sym !sym_max; incr sym_max; !sym_max in

  let litcls = Hashtbl.create 10000 in
  let filelines = IO.lines_of stdin in
  Enum.iter
    (fun line -> try Scanf.sscanf line "%d\t%d\t%s\t%s"
      (fun p n lit cl ->
         let litno = get_symno sym_no lit in
         let clno = get_symno sym_no cl in
         Hashtbl.modify_def (0,0) (litno, clno) (add2 (p, n)) litcls)
      with End_of_file -> Format.eprintf "unmatched line: %s\n" line
    ) filelines;
  Format.printf "%d\n" !sym_max;
  Hashtbl.iter (fun sym no -> Format.printf "%d\t%s\n" no sym) sym_no;
  Hashtbl.iter (fun (lit, cl) (p, n) -> Format.printf "%d\t%d\t%d\t%d\n" p n lit cl) litcls
