let md5s s = Int64.to_int ((Obj.magic (Digest.to_hex (Digest.string s))) : int64)

let cnst_no, no_cnst = Hashtbl.create 100, Hashtbl.create 100

let rec find_free_const n =
  if Hashtbl.mem no_cnst n || Hashtbl.mem no_cnst (-n) then
    find_free_const (if n + 1 < 0 then 1 else n + 1) else n

let const_number name =
  try Hashtbl.find cnst_no name with Not_found ->
    let cno = find_free_const (abs (md5s name)) in
    Hashtbl.add cnst_no name cno; Hashtbl.add no_cnst cno name; cno

let const name args = Term.A (const_number name, args)
let pred name args = Fof.Atom (const_number name, args)


let var_no, no_var, var_num = Hashtbl.create 100, Hashtbl.create 100, ref 0

let var (name : string) =
  try Hashtbl.find var_no name with Not_found ->
    incr var_num;
    Hashtbl.add var_no name !var_num; Hashtbl.add no_var !var_num name;
    !var_num

let eqn = const_number "="

let hash = const_number "'#'"
let hash_fof = Fof.Atom(hash, [])
let hash_lit = (-hash, [])
