#!/bin/sh
#-----------
# File:      nanocop.sh
# Version:   1.0
# Date:      16 January 2016
#-----------
# Purpose:   Invokes the nanoCoP prover
# Usage:     ./nanocop.sh <problem file>
# Author:    Jens Otten
# Web:       www.leancop.de/nanocop/
# Copyright: (c) 2016 by Jens Otten
# License:   GNU General Public License
#-----------

#-----------
# Parameters

# set the nanoCoP prover path
PROVER_PATH=`dirname $0`

# set Prolog system (ECLiPSe 5.x) and path
PROLOG=eclipse
PROLOG_PATH=~/Downloads/eclipse-5.10_147/bin/x86_64_linux/eclipse
PROLOG_OPTIONS='-e'

# set TPTP library path
# export TPTP=.

if [ $# -eq 0 -o $# -gt 1 ]; then
 echo "Usage: $0 <problem file>"
 exit 2
fi

if [ ! -r "$1" ]; then
 echo "Error: File $1 not found" >&2
 exit 2
fi

FILE=$1
SET=${SET:-'[cut,comp(6)]'}

$PROLOG_PATH $PROLOG_OPTIONS \
   "assert(prolog('$PROLOG')),\
    ['$PROVER_PATH/nanocop_main.pl'],\
    nanocop_main('$FILE',$SET,_),\
    halt."

