%% File: nanocop_main.pl  -  Version: 1.0  -  Date: 16 January 2016
%%
%% Purpose: Call the nanoCoP core prover for a given formula
%%
%% Authors: Jens Otten
%% Web:     www.leancop.de/nanocop/
%%
%% Usage:   nanocop_main(X,S,R). % proves formula in file X with
%%                               %  settings S and returns result R
%%
%% Copyright: (c) 2016 by Jens Otten
%% License:   GNU General Public License

:- dynamic(axiom_path/1).

% execute predicates specific to Prolog dialect

:- nodbgcomp,  % switch off debugging mode
   set_flag(print_depth,10000),  % set print depth
   set_flag(variable_names,off),
   ( getenv('TPTP',Path) -> Path1=Path ; Path1='' ),
   retract_all(axiom_path(_)), assert(axiom_path(Path1)),
   [nanocop].  % load nanoCoP core prover

% load additional nanoCoP components

:- [nanocop_tptp2].  % load module to support TPTP syntax

%%% call nanoCoP core prove

nanocop_main(File,Settings,Result) :-
    axiom_path(AxPath), ( AxPath='' -> AxDir='' ;
    name(AxPath,AxL), append(AxL,[47],DirL), name(AxDir,DirL) ),
    ( leancop_tptp2(File,AxDir,[_],F,Conj) ->
      Problem=F ; [File], f(Problem), Conj=non_empty ),
    ( Conj\=[] -> Problem1=Problem ; Problem1=(~Problem) ),
    leancop_equal(Problem1,Problem2),
    ( prove2(Problem2,Settings,Proof) ->
      ( Conj\=[] -> Result='Theorem' ; Result='Unsatisfiable' ) ;
      ( Conj\=[] -> Result='Non-Theorem' ; Result='Satisfiable' )
    ),
    output_result(File,Matrix,Proof,Result,Conj).

% print status and connection proof

output_result(File,Matrix,Proof,Result,Conj) :-
    ( Conj\=[] -> Art=' is a ' ; Art=' is ' ), nl,
    print(File), print(Art), print(Result), nl,
    Proof=[] -> true ; ( Result='Theorem' -> Out=' for ' ;
      Result='Unsatisfiable' -> Out=' for negated ' ; true ),
   ( var(Out) -> true ; print('Start of proof'), print(Out),
     print(File), nl, print(Proof), nl,
     print('End of proof'), print(Out), print(File), nl ).
