open Batteries
open Mapping
open Fof

let th_types =
  ["axiom"; "hypothesis"; "definition"; "lemma"; "theorem"; "plain"]

let forms_with_type p ths =
  List.map (fun (_, _, x) -> x) (List.filter (fun (_, x, _) -> p x) ths)

let conjoin_forms = function
    h :: t -> Some (List.fold_left conj h t)
  | [] -> None

let split_goal fofs =
  let ths = forms_with_type (fun x -> List.mem x th_types) fofs
  and cjs = forms_with_type ((=) "conjecture") fofs
  and ncs = forms_with_type ((=) "negated_conjecture") fofs in
  let th = conjoin_forms ths
  and gl = conjoin_forms (List.map neg ncs @ cjs) in
  (th, gl)

let add_hash (th, gl) = (th, Option.map (conj hash_fof) gl)

let combine_goal = function
    (Some th, Some gl) -> Impl (th, gl)
  | (Some th, None) -> Neg th
  | (None, Some gl) -> gl
  | (None, None) -> failwith "combine_goal"


let nocontent_skolem () =
  let skolem_no = ref 0 in
  fun tm pos -> incr skolem_no; "sk" ^ string_of_int !skolem_no

let content_skolem tm pos =
  "'skolem(" ^ String.filter ((<>) '\'') (Print.string_of_form tm) ^ "," ^ pos ^ ")'"

let skolem content =
  skolem_form const_number (if content then content_skolem else nocontent_skolem ())
