% definitions of logical connectives and quantifiers
:- [nanocop_tptp2].

r(0, g0 => g0).

r(N, F) :-
  N > 0,
  M is N-1,
  r(M, S),

  atom_codes('p',PC), atom_codes('g',GC),
  number_codes(N,NC),
  append(PC,NC,PNC), append(GC,NC,GNC),
  atom_codes(PN,PNC), atom_codes(GN,GNC),

  PNX =.. [PN, X],
  PNY =.. [PN, Y],

  F = ((? [X]: PNX | GN) => (? [Y]: (PNY | GN) & S)).
  
formula(N, fof(1, conjecture, F)) :- r(N, F).
