import Data.List (intercalate)

var n = "X" ++ show n
prd n m = "p" ++ show m ++ "(" ++ intercalate "," (map var [m .. n]) ++ ")"

data Quantifier = Existential | Universal

change Existential = Universal
change Universal = Existential

instance Show Quantifier where
  show Existential = "?"
  show Universal = "!"

hardBinder Existential = " & "
hardBinder Universal = " | "

frm n 0 _ = prd n 1
frm n m q =
  show q ++ "[" ++ var m ++ "]: " ++
  "(" ++ prd n m ++ hardBinder q ++ frm n (m-1) (change q) ++ ")"

axiom t = "fof(1, axiom,      (" ++ t ++ "))."
conj  t = "fof(1, conjecture, (" ++ t ++ "))."

main = mapM_ putStrLn [axiom formula, conj formula]
  where formula = frm 20 20 Universal
